/*
 * Decompiled with CFR 0.152.
 */
package memory;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import memory.Maushorcher;
import memory.Person;
import memory.Punkte;
import memory.Spiel;
import memory.VerticalLabelUI;

public class Spieler
extends JPanel {
    Box links = Box.createVerticalBox();
    Box rechts = Box.createVerticalBox();
    int schriftgr\u00f6\u00dfe = 18;
    boolean abr\u00e4umen = false;

    Spieler() {
        this.links.add(Box.createVerticalGlue());
        this.rechts.add(Box.createVerticalGlue());
        this.vorbereiten(false);
        this.addMouseListener(new Maushorcher(this));
    }

    void vorbereiten(boolean zwinge) {
        this.removeAll();
        if (this.links.getComponentCount() > 1 || zwinge) {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.links);
            this.add(this.rechts);
        } else {
            this.setLayout(new BorderLayout());
            JLabel anl = new JLabel("Klicke hier mit der rechten Maustaste, wenn du die Spieler eintragen m\u00f6chtest, die in der n\u00e4chsten Runde mitspielen werden.");
            anl.setUI(new VerticalLabelUI(false));
            anl.setHorizontalAlignment(0);
            this.add((Component)anl, "Center");
        }
        if (!zwinge) {
            this.setToolTipText("Spieler verwalten");
        } else {
            this.setToolTipText(null);
        }
    }

    public void nullen() {
        for (int i = 0; i < this.links.getComponentCount() - 1; ++i) {
            ((Punkte)this.links.getComponent(i)).setText("0");
        }
        this.erfrischen();
    }

    public void starten() {
        this.vorbereiten(true);
        boolean neu = true;
        for (int i = 0; i < this.links.getComponentCount() - 1; ++i) {
            if (!((Person)this.rechts.getComponent(i)).isOpaque()) continue;
            neu = false;
        }
        if (neu && this.links.getComponentCount() > 1) {
            ((Person)this.rechts.getComponent(0)).setOpaque(true);
        }
        this.erfrischen();
    }

    public void aktiv(Component c) {
        int alt = -1;
        int neu = -1;
        Component[] p = this.rechts.getComponents();
        for (int i = 0; i < p.length; ++i) {
            if (p[i].equals(c)) {
                neu = i;
            }
            if (!this.rechts.getComponent(i).isOpaque()) continue;
            alt = i;
        }
        if (neu > -1) {
            if (alt > -1) {
                ((Person)this.rechts.getComponent(alt)).setOpaque(false);
            }
            ((Person)this.rechts.getComponent(neu)).setOpaque(true);
        }
        this.erfrischen();
    }

    public void n\u00e4chster() {
        int alt = -1;
        int neu = -1;
        for (int i = 0; i < this.links.getComponentCount() - 1; ++i) {
            if (!((Person)this.rechts.getComponent(i)).isOpaque()) continue;
            alt = i;
        }
        if (alt > -1) {
            neu = alt < this.links.getComponentCount() - 2 ? alt + 1 : 0;
            ((Person)this.rechts.getComponent(alt)).setOpaque(false);
            Person neuer = (Person)this.rechts.getComponent(neu);
            neuer.setOpaque(true);
            Spiel.nxt.wechsel(neuer.name);
        }
        this.erfrischen();
    }

    public void punkten() {
        for (int i = 0; i < this.links.getComponentCount() - 1; ++i) {
            if (!((Person)this.rechts.getComponent(i)).isOpaque()) continue;
            ((Punkte)this.links.getComponent(i)).setText(Integer.toString(Integer.parseInt(((Punkte)this.links.getComponent(i)).getText()) + 1));
        }
        this.erfrischen();
    }

    public void erfrischen() {
        this.revalidate();
        this.repaint();
    }

    public void neuer(String s, String n, Component c) {
        int pos = -1;
        if (this.equals(c)) {
            pos = this.rechts.getComponentCount() - 1;
        } else {
            Component[] p = this.rechts.getComponents();
            if (c == null) {
                pos = p.length - 1;
            } else {
                for (int i = 0; i < p.length; ++i) {
                    if (!p[i].equals(c)) continue;
                    pos = i;
                }
            }
        }
        if (pos > -1) {
            this.links.add((Component)new Punkte(n), pos);
            this.rechts.add((Component)new Person(s), pos);
            this.vorbereiten(false);
            this.erfrischen();
        }
    }

    public void schrift(int s) {
        if (s > 5 && s < 55) {
            Spiel.spl.schriftgr\u00f6\u00dfe = s;
            for (int i = 0; i < this.rechts.getComponentCount() - 1; ++i) {
                ((Punkte)this.links.getComponent(i)).schrift();
                ((Person)this.rechts.getComponent(i)).festeGr\u00f6\u00dfe(false);
                ((Person)this.rechts.getComponent(i)).schrift();
                ((Person)this.rechts.getComponent(i)).festeGr\u00f6\u00dfe(true);
            }
            this.erfrischen();
        }
    }

    public void l\u00f6schen(Component c) {
        Component[] p = this.rechts.getComponents();
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].equals(c)) continue;
            this.rechts.remove(i);
            this.links.remove(i);
        }
        this.vorbereiten(false);
        this.erfrischen();
    }

    public boolean istKurz() {
        return !this.abr\u00e4umen;
    }
}

